/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.resources;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationTemplateResourceLoader;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.JsonRegistryResourceLoader;
import com.ferreusveritas.dynamictrees.deserialisation.JsonHelper;
import com.ferreusveritas.dynamictrees.deserialisation.ResourceLocationDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.MushroomShapeConfiguration;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.shapekits.MushroomShapeKit;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CapPropertiesResourceLoader
extends JsonRegistryResourceLoader<CapProperties> {
    public static final CapPropertiesResourceLoader CAP_PROPERTIES_LOADER = new CapPropertiesResourceLoader();
    public static ConfigurationTemplateResourceLoader<MushroomShapeConfiguration, MushroomShapeKit> MUSHROOM_SHAPE_KIT_TEMPLATE_LOADER = new ConfigurationTemplateResourceLoader("mushroom_shape_kits/configurations", MushroomShapeKit.REGISTRY, MushroomShapeConfiguration.TEMPLATES);
    public static final String CAP_PROPERTIES = "cap_properties";

    public CapPropertiesResourceLoader() {
        super(CapProperties.REGISTRY, CAP_PROPERTIES);
    }

    public void registerAppliers() {
        this.gatherDataAppliers.register("primitive_cap", Block.class, CapProperties::setPrimitiveCap).register("generate_face_models", Boolean.class, CapProperties::setGenerateFaceModels).registerMapApplier("texture_overrides", ResourceLocation.class, CapProperties::setTextureOverrides).registerMapApplier("model_overrides", ResourceLocation.class, CapProperties::setModelOverrides).register("mushroom_item", Item.class, CapProperties::setMushroomItem);
        this.setupAppliers.register("primitive_cap", Block.class, CapProperties::setPrimitiveCap).register("family", ResourceLocation.class, (capProperties, registryName) -> {
            ResourceLocation processedRegName = TreeRegistry.processResLoc((ResourceLocation)registryName);
            Family.REGISTRY.runOnNextLock(Family.REGISTRY.generateIfValidRunnable(processedRegName, capProperties::setFamily, () -> this.logWarning(capProperties.getRegistryName(), "Could not set family for cap properties with name \"" + String.valueOf(capProperties) + "\" as family \"" + String.valueOf(processedRegName) + "\" was not found.")));
        });
        this.reloadAppliers.register("fire_spread", Integer.class, CapProperties::setFireSpreadSpeed).register("flammability", Integer.class, CapProperties::setFlammability).register("age_zero_shape", VoxelShape.class, CapProperties::setAgeZeroShape);
        super.registerAppliers();
    }

    protected void applyLoadAppliers(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        CapProperties capProperties = (CapProperties)loadData.getResource();
        this.readCustomBlockRegistryName(capProperties, json);
        if (this.shouldGenerateBlocks(json).booleanValue()) {
            this.generateBlocks(capProperties, json);
        }
        super.applyLoadAppliers(loadData, json);
    }

    private void readCustomBlockRegistryName(CapProperties capProperties, JsonObject json) {
        JsonResult.forInput((JsonElement)json).mapIfContains("block_registry_name", JsonElement.class, input -> (ResourceLocation)ResourceLocationDeserialiser.create((String)capProperties.getRegistryName().m_135827_()).deserialise(input).orElseThrow(), (Object)capProperties.getBlockRegistryName()).ifSuccessOrElse(capProperties::setBlockRegistryName, error -> this.logError(capProperties.getRegistryName(), (String)error), warning -> this.logWarning(capProperties.getRegistryName(), (String)warning)).mapIfContains("center_block_registry_name", JsonElement.class, input -> (ResourceLocation)ResourceLocationDeserialiser.create((String)capProperties.getRegistryName().m_135827_()).deserialise(input).orElseThrow(), (Object)capProperties.getCenterBlockRegistryName()).ifSuccessOrElse(capProperties::setCenterBlockRegistryName, error -> this.logError(capProperties.getRegistryName(), (String)error), warning -> this.logWarning(capProperties.getRegistryName(), (String)warning));
    }

    private Boolean shouldGenerateBlocks(JsonObject json) {
        return (Boolean)JsonHelper.getOrDefault((JsonObject)json, (String)"generate_block", Boolean.class, (Object)true);
    }

    public MapColor getDefaultMapColor() {
        return MapColor.f_283915_;
    }

    private void generateBlocks(CapProperties capProperties, JsonObject json) {
        BlockBehaviour.Properties blockProperties = JsonHelper.getBlockProperties((JsonObject)json, (MapColor)capProperties.getDefaultMapColor(), capProperties::getDefaultBlockProperties, error -> this.logError(capProperties.getRegistryName(), (String)error), warning -> this.logWarning(capProperties.getRegistryName(), (String)warning));
        capProperties.generateDynamicCapBlocks(blockProperties);
    }
}

